% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVCCAT}
\alias{IVCCAT}
\title{Integrated Variance Correlation Based Hypothesis Test for Discrete Response}
\usage{
IVCCAT(y, x, K, num_per, type)
}
\arguments{
\item{y}{is a categorical response vector}

\item{x}{is a numeric vector}

\item{K}{is the number of quantile levels}

\item{num_per}{is the number of permutation times}

\item{type}{is an indicator for fixed number of categories or infinity number of categories, "fixed" represents number of categories is fixed, then a permutation test is used, "infinity" represents number of categories is infinite, then an asymptotic normal distribution is used to calculate p values}
}
\value{
The p-value of the corresponding hypothesis test
}
\description{
This function is used to test independence between a categorical variable and a continuous variable using integrated variance correlation
}
\examples{
# small R
n=100
x=runif(n,0,1)
y=sample(rep(1:3), n, replace = TRUE, prob = c(1/3,1/3,1/3))

IVCCAT(y,x,K=5,num_per=20,type = "fixed")
# large R
n=200
y=sample(rep(1:20), n, replace = TRUE, prob = rep(1/20,20))
mu_x=sample(c(1,2,3,4),20,replace = TRUE,prob = c(1/4,1/4,1/4,1/4))
x=c()
for (i in 1:n) {
 x[i]=2*mu_x[y[i]]+rcauchy(1)
}

IVCCAT(y,x,K=10,type = "infinity")
}
