% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNdynamic_function.R
\name{ITNdynamic}
\alias{ITNdynamic}
\title{Dynamic ITN}
\usage{
ITNdynamic(NETlist)
}
\arguments{
\item{NETlist}{A list of International Trade Networks (igraph objects)}
}
\value{
It returns the Dynamic Network Object
}
\description{
This function produces a dynamic network object for ITNs. It cleans and adjusts the individual networks, so they are the same size. This dynamic network object can then be used to create animations, mapping changes over time and to calculate temporal network statistics
}
\examples{
\donttest{
require(igraph)

##Create a set of random International Trade Networks (igraph objects)
##and add vertex names
ITN1<-erdos.renyi.game(75,0.05,directed = TRUE)
V(ITN1)$name<-1:vcount(ITN1)
ITN2<-erdos.renyi.game(100,0.01,directed = TRUE)
V(ITN2)$name<-1:vcount(ITN2)
ITN3<-erdos.renyi.game(55,0.1,directed = TRUE)
V(ITN3)$name<-1:vcount(ITN3)

##Create network list
NETlist<-list(ITN1,ITN2,ITN3)

##Create Dynamic Network Object

ITNdyn<-ITNdynamic(NETlist)
}
}
