% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survreport.R
\name{survreport}
\alias{survreport}
\title{Survival analysis on the reconstructed IPD}
\usage{
survreport(ipd1,ipd2=NULL,arms=1,interval=6,s=c(0.75,0.5,0.25),showplots=TRUE)
}
\arguments{
\item{ipd1}{a three-column (i.e., time, status, and treatment indicator)table of IPD for treatment 1.}

\item{ipd2}{a three-column (i.e., time, status, and treatment indicator)table of IPD for treatment 2.}

\item{arms}{number of treatment group. Can be either 1 or 2.}

\item{interval}{length of the time interval for which the landmark survival probabilities are of interest. The default is at every 6 months.}

\item{s}{a vector with survival probabilities for which the corresponding survival times are reported. e.g., s=0.5 means that the median survival time is desired.}

\item{showplots}{indicate if the survival plots are displayed or not in the plot window}
}
\value{
\code{survreport()} returns a list object. \cr
}
\description{
Graph the Kaplan-Meier curves and the cumulative hazard curves for the
            reconstructed IPD (from the output of \code{\link{getIPD}} function). Also report
            the survival times with confidence intervals for a given vector of survival probabilities,
            as well as the landmark survival probabilities of interest.(for example, if set interval=6,
            the survival probability will be reported at every six months)
}
\examples{
### Get data from the sample dataset=======================
radio <- Radiationdata$radio
radioplus <- Radiationdata$radioplus
trisk <- Radiationdata$trisk
nrisk_radio <- Radiationdata$nrisk.radio
nrisk_radioplus <- Radiationdata$nrisk.radioplus
### Estimate the IPD for the Radiotherapy treatment group ====================
pre_radio <- preprocess(dat=radio, trisk=trisk,nrisk=nrisk_radio,maxy=100)
est_radio <- getIPD(prep=pre_radio,armID=0,tot.events=NULL)
### Estimate the IPD for the Radiotherapy plus treatment group ====================
pre_radio_plus <- preprocess(dat=radioplus, trisk=trisk,nrisk=nrisk_radioplus,maxy=100)
est_radio_plus <- getIPD(prep=pre_radio_plus,armID=1,tot.events=NULL)
### survival report for one arm ===================
surv1 <- survreport(ipd1=est_radio$IPD,arms=1,interval=6,s=c(0.75,0.5,0.25),showplots=FALSE)
print(surv1)
surv1 <- survreport(ipd1=est_radio$IPD,arms=1,interval=10,s=seq(0,1,0.2),showplots=TRUE)
print(surv1)
### survival report for two arms ===================
surv2 <- survreport(ipd1=est_radio$IPD,ipd2=est_radio_plus$IPD,arms=2,
                    interval=8,s=c(0.75,0.5,0.25),showplots=TRUE)
print(surv2)

}
\references{
Guyot P, Ades AE, Ouwens MJ, Welton NJ. Enhanced secondary analysis of survival data: reconstructing the data from published Kaplan-Meier survival curves. BMC Med Res Methodol.2012; 1:9.
}
