% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.INLAjoint.R
\name{predict.INLAjoint}
\alias{predict.INLAjoint}
\title{Computes predictions for a given model fitted with INLAjoint}
\usage{
\method{predict}{INLAjoint}(
  object,
  newData = NULL,
  newDataSurv = NULL,
  timePoints = NULL,
  NtimePoints = 50,
  NsampleHY = 20,
  NsampleFE = 20,
  NsampleRE = 50,
  id = NULL,
  Csurv = NULL,
  startTime = NULL,
  horizon = NULL,
  baselineHaz = "interpolation",
  return.samples = FALSE,
  FEonly = FALSE,
  survival = FALSE,
  CIF = FALSE,
  inv.link = FALSE,
  NidLoop = "auto",
  resErrLong = FALSE,
  set.samples = NULL,
  silentMode = FALSE,
  ...
)
}
\arguments{
\item{object}{an object that contains a model fitted with INLAjoint.}

\item{newData}{a dataset with the same columns as those used to fit the model. When using a longitudinal
marker to predict longitudinal and subsequent survival outcomes, only the longitudinal information (i.e.,
structure of the longitudinal data) is required. It is also possible to predict the average trajectories
conditional on covariates by setting the value of the longitudinal outcomes included in the model to NA.}

\item{newDataSurv}{a dataset for survival information (only useful when both longitudinal and survival
data are provided for the predictions, otherwise using the argument newData is working too).}

\item{timePoints}{a vector of the time points at which predictions are computed (for both longitudinal
and survival outcomes), this also control the precision of the integration for time-dependent shared
terms and the computation of cumulative risks (e.g., for survival or CIF curves), thus many time points
will increase the accuracy of predictions. Default is NULL as these time points are automatically computed
when not defined manually.}

\item{NtimePoints}{number of time points at which the predictions are computed (for both longitudinal
and survival outcomes), these time points are equidistant between time 0 and horizon time.
This also control the precision of the integration for time-dependent shared
terms and the computation of cumulative risks (e.g., for survival or CIF curves), thus many time points
will increase the accuracy of predictions.}

\item{NsampleHY}{number of samples for hyperparameters used to assess uncertainty
when computing predictions. Default is 20.}

\item{NsampleFE}{number of samples of fixed effects for each hyperparameters samples
used to assess uncertainty when computing predictions. Default is 30 (i.e., 30 x NsampleHY).}

\item{NsampleRE}{number of random effects realizations for each sample specified in 'NsampleHY' and
'NsampleFE'. Default is 50 (i.e., 50 x NsampleFE x NsampleHY, resulting in 20000 random effects samples
per new individual with default values). These random effects realizations are conditional on
observed longitudinal outcomes values provided in 'newData' and survival time provided in 'newDataSurv'
when a survival model is included. If 'newDataSurv' is NULL, they are conditional on
survival up to latest longitudinal recorded measurement. When outcomes are
set to NA, the realizations are sampled from the marginal distribution of random effects.}

\item{id}{name of the individual id variable, default is NULL as it is automatically grabbed from the
fitted model but when fitting simple survival models, providing id when fitting the model is not
mandatory and thus this can be useful (an explicit message is printed in this specific case).}

\item{Csurv}{conditional survival, gives the starting value of the at-risk period (i.e., starting value
at which risk predictions for survival models are computed).
Default is the last longitudinal observation time provided in 'newData' but this is
replaced by the value of 'Csurv' when provided.}

\item{startTime}{define a starting time for predictions.}

\item{horizon}{horizon of the prediction.}

\item{baselineHaz}{method used to evaluate the baseline hazard value, default is 'interpolation'
which is currently recommended. Experimental alternatives are being developed, including 'splines'
for an interpolation with splines but has not been properly validated with simulations yet.}

\item{return.samples}{boolean, when set to TRUE the samples are returned instead of summary
statistics over the samples. Default is FALSE.}

\item{FEonly}{boolean, when set to TRUE, only fixed effects are involved for predictions computations.}

\item{survival}{boolean, when set to TRUE the summary statistics over survival functions are
computed in addition to the summary statistics over the risk functions.}

\item{CIF}{boolean, when set to TRUE the summary statistics over cumulative incidence functions are
computed in addition to the summary statistics over the risk functions. Only applies to competing risks.}

\item{inv.link}{boolean, when set to TRUE the summary statistics are computed over the predictions of
longitudinal components after applying the inverse link function for each samples in addition to the
summary statistics over the linear predictors.}

\item{NidLoop}{Gives the number of individuals for which we compute predictions at once. For large number
of individuals, this will loop over groups of 'NidLoop' individuals and could make predictions computations faster.}

\item{resErrLong}{boolean, when set to TRUE the residual error for Gaussian or lognormal longitudinal
outcomes is added to the uncertainty of predictions (default is FALSE which predicts the true underlying
value of the longitudinal marker, i.e., error-free).}

\item{set.samples}{replace random effects with pre-sampled values.}

\item{silentMode}{a boolean that will stop printing messages during computations if turned to TRUE.}

\item{...}{Extra arguments.}
}
\description{
This function allows to compute predictions for a given model fitted with INLAjoint,
the default behavior (without arguments) returns fitted values for each component of the model. It
is also possible to supply a dataset for which predictions are required, this dataset must have
the same structure as the dataset used for the model fitting (i.e., same columns). The default
returned predictions corresponds to the linear predictors for each outcomes.
}
