% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.qcdata.R
\name{lab.qcdata}
\alias{lab.qcdata}
\title{Quality Control Data}
\usage{
lab.qcdata(
  data,
  var.index = 1,
  replicate.index = 2,
  material.index = 3,
  laboratory.index = 4,
  data.name = NULL
)
}
\arguments{
\item{data}{A matrix or data-frame that contains the data, replicate index, type of material, and the laboratory.}

\item{var.index}{A scalar with the column number corresponding to the observed variable (the critical to quality variable).
Alternativelly can be a string with the name of the quality variable.}

\item{replicate.index}{A scalar with the column number corresponding to the index each replicate.}

\item{material.index}{A scalar corresponding to the replicated number.}

\item{laboratory.index}{A scalar that defines the index number of each laboratory.}

\item{data.name}{A string specifying the name of the variable which appears on the plots.
If name is not provided, it is taken from the object given as data.}
}
\description{
It creates a 'lab.qcdata' class object to perform the interlaboratory study.
This object is used to plot ILS data and more.
}
\examples{
library(ILS)
data(Glucose)
Glucose.qcdata <- lab.qcdata(Glucose)
str(Glucose.qcdata)
summary(Glucose.qcdata)
}
