% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{ht_ID_pcm}
\alias{ht_ID_pcm}
\title{Apply the Isolate-Detect methodology for multiple change-point detection in the
mean of a vector with non Gaussian noise}
\usage{
ht_ID_pcm(x, s.ht = 3, q_ht = 300, ht_thr_id = 1, ht_th_ic_id = 0.9,
  p_thr = 1, p_ic = 3)
}
\arguments{
\item{x}{A numeric vector containing the data in which you would like to find
change-points.}

\item{s.ht}{A positive integer number with default value equal to 3. It is
used to define the way we pre-average the given data sequence (see Details).}

\item{q_ht}{A positive integer number with default value equal to 300. If the
length of \code{x} is less than or equal to \code{q_ht}, then no pre-averaging
will take place.}

\item{ht_thr_id}{A positive real number with default value equal to 1. It is
used to define the threshold, if the thresholding approach is to be followed; see
\code{\link{pcm_th}} for more details on the thresholding approach.}

\item{ht_th_ic_id}{A positive real number with default value equal to 0.9. It is
useful only if the model selection based Isolate-Detect method is to be followed
and it is used to define the threshold value that will be used at the first step
(change-point overestimation) of the model selection approach described in
\code{\link{pcm_ic}}. It is applied to the new data, which are obtained after
we pre-average \code{x}.}

\item{p_thr}{A positive integer with default value equal to 1. It is used only
when the threshold based approach (as described in \code{\link{pcm_th}}) is to be followed
and it defines the distance between two consecutive end- or start-points of the right- or
left-expanding intervals, respectively.}

\item{p_ic}{A positive integer with default value equal to 3. It is used only
when the information criterion based approach (described in \code{\link{pcm_ic}})
is to be followed and it defines the distance between two consecutive end- or start-points
of the right- or left-expanding intervals, respectively.}
}
\value{
A list with the following components:
  \tabular{ll}{
   \cr \code{cpt} \tab A vector with the detected change-points.
   \cr \code{no_cpt} \tab The number of change-points detected.
   \cr \code{fit} \tab A numeric vector with the estimated piecewise-constant signal.
   \cr \code{solution_path} \tab A vector containing the solution path.
 }
}
\description{
Using the Isolate-Detect methodology, this function estimates the number and locations
of multiple change-points in the mean of the noisy, piecewise-constant input vector \code{x},
with noise that is not normally distributed. It also gives the estimated signal, as well as
the solution path defined in \code{\link{sol_path_pcm}}. See Details for the relevant literature reference.
}
\details{
Firstly, in this function we call \code{\link{normalise}}, in order to
  create a new data sequence, \eqn{\tilde{x}}, by taking averages of observations in
  \code{x}. Then, we employ \code{\link{ID_pcm}} on \eqn{\tilde{x}_q} to obtain the
  change-points, namely \eqn{\tilde{r}_1, \tilde{r}_2, ..., \tilde{r}_{\hat{N}}} in
  increasing order. To obtain the original location of the change-points with,
  on average, the highest accuracy we define
  \eqn{\hat{r}_k = (\tilde{r}_{k}-1)*\code{s.ht} + \lfloor \code{s.ht}/2 + 0.5 \rfloor, k=1, 2,..., \hat{N}.}
  More details can be found in ``Detecting multiple generalized change-points by
  isolating single ones'', Anastasiou and Fryzlewicz (2018), preprint.
}
\examples{
single.cpt <- c(rep(4,3000),rep(0,3000))
single.cpt.student <- single.cpt + rt(6000, df = 5)
cpts_detect <- ht_ID_pcm(single.cpt.student)

three.cpt <- c(rep(4,2000),rep(0,2000),rep(-4,2000),rep(0,2000))
three.cpt.student <- three.cpt + rt(8000, df = 5)
cpts_detect_three <- ht_ID_pcm(three.cpt.student)
}
\seealso{
\code{\link{ID_pcm}} and \code{\link{normalise}}, which are functions that are
used in \code{\link{ht_ID_pcm}}. In addition, see \code{\link{ht_ID_cplm}} for the case
of continuous and piecewise-linear signals.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
