% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_ICODS.R
\name{minAIC}
\alias{minAIC}
\title{Retrieve the Minimum AIC}
\usage{
minAIC(object, ...)
}
\arguments{
\item{object}{An object of class ICODS}

\item{...}{ignored}
}
\value{
numeric
}
\description{
Retrieves the minimum AIC.
}
\examples{

data(odsData)

resultODS <- ODSDesignIC(U = odsData$U, 
                         V = odsData$V,  
                         del1 = odsData$del1,  
                         del2 = odsData$del2, 
                         z = odsData$z, 
                         mVal = 1L, 
                         ind = odsData$ind, 
                         a1 = 0.43, 
                         a2 = 0.45, 
                         beta = NULL, 
                         maxit = 10L,
                         verbose = TRUE)

minAIC(resultODS)

data(ccData)

resultCC <- CaseCohortIC(U = ccData$U, 
                         V = ccData$V,  
                         del1 = ccData$del1,  
                         del2 = ccData$del2, 
                         xi = ccData$xi,
                         z = ccData$z, 
                         sp = 0.2, 
                         mVal = 1L,
                         B = 10L, 
                         beta = NULL, 
                         maxit = 10L,
                         verbose = TRUE)

minAIC(resultCC)

}
