% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\docType{class}
\name{population}
\alias{population}
\title{Class population}
\usage{
population(x, entry = FALSE, out = FALSE, id = FALSE)
}
\arguments{
\item{x}{Data frame or list of data frames, containing at least a birth and a death column}

\item{entry}{Boolean flag. By default set to FALSE. If set to TRUE the population must contain a column of numerical values named "entry",
If the column doesn't exist a column named "entry" is added to the data frame with all values set to NA.}

\item{out}{Boolean flag. By default set to FALSE. If set to TRUE the population must contain a column of boolean values named "out",
If the column doesn't exist a column named "out" is added to the data frame with all the values set to FALSE.}

\item{id}{Boolean flag. By default set to FALSE. If set to TRUE the population must contain a column of integer distinct values named "id".
If the column doesn't exist a column named "id" is added to the data frame with values seq(1, nrow(x)).}
}
\value{
Given data frame augmented of the "population" class. If a list of data frames is given,
the column names should contain the string "id" and the list corresponds to the evolution of a population
at different times. The constructor then returns the last population observed in the list
(corresponding to the final state of the population).
}
\description{
Data frame containing a population,
with at least a birth and a death column, and eventually some other characteristics
}
