#' Sample Gender Stereotype Implicit Association Test data
#'
#' @name IATData
#' @docType data
#' @description A dataframe containing data from a Gender Stereotype Implicit Association Test. Data was taken from college students in a 
#' differential equations classroom taught by a female professor.
#' @format A dataframe with 11792 observations of 16 variables (88 students in total)
#' 
#' \itemize{
#'   \item BLOCK_NAME_S: string of blocknames
#'   \item BLOCK_PAIRING_DEFINITION_S: string of block pairings
#'   \item TRIAL_NAME_S: word/picture used in sorting trial
#'   \item SESSION_ID: ID of participant
#'   \item TRIAL_NUMBER: number of trial within block
#'   \item TRIAL_ERROR: indicates whether trial was an error (1 = YES)
#'   \item TRIAL_LATENCY: reaction time for trial
#'   \item isCongruentFirst: indicates if stereotype congruent blocks came first
#' }
#' 
#' 
#' @author Dan Martin {dpmartin42@gmail.com}
#' @references \url{http://projectimplicit.net/fpi/researchers.html}
#' @keywords IAT Implicit Association Test
NULL