% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PartialDependencePlot.R
\name{pdpEst_mpfr}
\alias{pdpEst_mpfr}
\title{Partial dependence plot with specific numerical precision}
\usage{
pdpEst_mpfr(
  colInd,
  object,
  predictfun,
  X,
  centering = FALSE,
  outputVector = TRUE,
  newX = NULL,
  nCores = 1,
  precBits = 53 * 2
)
}
\arguments{
\item{colInd}{Index of columns of covariates to specify the null hypothesis 
set \emph{s} (integer vector).}

\item{object}{Prediction model object (class flexible).}

\item{predictfun}{Prediction function to be evaluated (class function). The
prediction function needs to be specified with two arguments 
\emph{predictfun(object, X)}. The argument \emph{object} is the prediction 
model and \emph{X} the data on which the partial dependence functions
are evaluated.}

\item{X}{Data on that the partial dependence function is evaluated 
(class matrix or data.frame). The structure of the data depends on the 
specified argument \emph{predictfun}.}

\item{centering}{Should the resulting values be mean centered? 
(logical scalar). Default corresponds to output original values.}

\item{outputVector}{Should be only the partial dependence function returned}

\item{newX}{Test data set (class "data.frame")}

\item{nCores}{Number of cores used in standard parallel computation
setup based on R \emph{parallel} package. The default value of one uses 
serial processing across observations.}

\item{precBits}{Numerical precision that are used in computation after the 
calculation of the predictions from the estimated model. Default is defined 
to be double the amount of the 53 Bits usually used in R.}
}
\value{
Vector of estimated the PDP curve values for each sample in \emph{X}.
}
\description{
Estimates the partial dependence plot (PDP) curve given specified numerical 
precision.
}
\examples{

#####################
# Simulation example

# Simulate covariates from multivariate standard normal distribution
set.seed(-72498)
library(mvnfast)
X <- mvnfast::rmvn(n=1e2, mu=rep(0, 2), sigma=diag(2))

# Response generation
y <- X[, 1]^2 + rnorm(n=1e2, mean=0, sd=0.5)
trainDat <- data.frame(X, y=y)

# Estimate generalized additive model
library(mgcv)
gamFit <- gam(formula=y~s(X1)+s(X2), data=trainDat, 
family=gaussian())

# Estimate PDP function
pdpEst1 <- pdpEst_mpfr(colInd=1, object=gamFit, 
predictfun=function(object, X){
predict(object=object, newdata=X, type="response")
}, X=trainDat, 
centering=FALSE, nCores=1, precBits=53*2)

# Convert to standard precision and order in sequence of observations
pdpEst1 <- as.numeric(pdpEst1)
ordInd <- order(X[, 1])
pdpEst1 <- pdpEst1[ordInd]

# Plot: PDP curve vs. true effect
plot(x=X[ordInd, 1], y=pdpEst1, type="l")
lines(x=X[ordInd, 1], y=X[ordInd, 1]^2, lty=2, col="red")
# -> Both curves are similiar

}
\references{
\insertRef{friedmanInteract}{IADT}
}
\seealso{
\code{\link{testIAD_mpfr}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{prediction}
