% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{Metropolis_OAAT_adaptive}
\alias{Metropolis_OAAT_adaptive}
\title{Adaptive One-At-A-Time Metropolis sampler}
\usage{
Metropolis_OAAT_adaptive(
  f,
  x0,
  sdjump,
  ...,
  batch.length = 100,
  batch.n = 100,
  moverate.min = 0.1,
  moverate.max = 0.5,
  mult.down = 0.9,
  mult.up = 1.1
)
}
\arguments{
\item{f}{function, log-pdf of the target distribution}

\item{x0}{numeric vector, starting point}

\item{sdjump}{numeric vector, initial standard deviation of the Gaussian jump for each component}

\item{...}{other arguments passed to f}

\item{batch.length}{integer, length of each non-adaptive batch}

\item{batch.n}{integer, number of batches (= adaptation period). Total number of simulations is nsim=batch.n*batch.length}

\item{moverate.min}{numeric in (0;1), lower bound for the desired move rate interval}

\item{moverate.max}{numeric in (0;1), upper bound for the desired move rate interval}

\item{mult.down}{numeric in (0;1), multiplication factor used to decrease jump size when move rate is too low.}

\item{mult.up}{numeric (>1, avoid 1/mult.down) multiplication factor used to increase jump size when move rate is too high.}
}
\value{
A list with the following components:
    \item{x}{numeric matrix nsim*length(x0), MCMC simulations}
    \item{fx}{numeric vector, corresponding values f(x)}
}
\description{
Performs nsim iterations of the Adaptive version of the OAAT Metropolis sampler
(see ?Metropolis_OAAT).
Adaptation is performed by monitoring move rates every batch.length iterations, and 
increasing / decreasing the jump standard deviation if the move rate is not within specified bounds.
}
\examples{
# Bivariate target distribution: beta(0.8,0.4) X exp(1)
f=function(x){stats::dbeta(x[1],0.8,0.4,log=TRUE)+stats::dexp(x[2],log=TRUE)}
x0=c(0.5,2)
sdjump=c(0.5,1)
mcmc=Metropolis_OAAT_adaptive(f,x0,sdjump)
graphicalpar=par(mfrow=c(1,3))
plot(mcmc$x);hist(mcmc$x[,1]); hist(mcmc$x[,2])
par(graphicalpar)
}
