% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_qpearsonIII.R
\name{calc_qlpearsonIII}
\alias{calc_qlpearsonIII}
\title{Quantile of Pearson Type III distribution for log-transformed data}
\usage{
calc_qlpearsonIII(p, meanlog = 0, sdlog = 1, skew = 0)
}
\arguments{
\item{p}{Vector of non-exceedance probabilities, between 0 and 1, to calculate quantiles.}

\item{meanlog}{Vector of mean of the distribution of the log-transformed data.}

\item{sdlog}{Vector of standard deviation of the distribution of the log-transformed data.}

\item{skew}{Vector of skewness of the distribution of the log-transformed data.}
}
\value{
Quantiles for the described distribution
}
\description{
Quantile of Pearson Type III distribution for log-transformed data
}
\details{
\code{\link{calc_qpearsonIII}} and \code{\link{calc_qlpearsonIII}} are functions to fit a log-Pearson type III
distribution from a given mean, standard deviation, and skew. This source code is replicated,
unchanged, from the \code{swmrBase} package in order to reduce the dependency on that package.
}
\examples{
calc_qlpearsonIII(0.1)

}
\references{
Asquith, W.H., Kiang, J.E., and Cohn, T.A., 2017, Application of at-site peak-streamflow
frequency analyses for very low annual exceedance probabilities: U.S. Geological Survey
Scientific Investigation Report 2017–5038, 93 p.
[Also available at https://doi.org/10.3133/sir20175038.]

Lorenz, D.L., 2015, smwrBase—An R package for managing hydrologic data, version 1.1.1: U.S.
Geological Survey Open-File Report 2015–1202, 7 p.\cr
[Also available at https://doi.org/10.3133/ofr20151202.]
}
\seealso{
\code{\link{calc_qpearsonIII}}
}
\keyword{period-of-record}
