% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotClassify}
\alias{PlotClassify}
\title{Plot Heterogeneity-seq Classifier Results}
\usage{
PlotClassify(
  table,
  highlights = NULL,
  highlights.color = NULL,
  auc.cutoff = NULL,
  plot.baseline = TRUE,
  density.color = TRUE,
  density.n = 500,
  point.scale = 0.5,
  xlab = "AUC",
  ylab = bquote(log[2] ~ FC ~ (`0h`)),
  linetype = "dashed"
)
}
\arguments{
\item{table}{Table from HetSeq using the Classifier method.}

\item{highlights}{A vector of genes to highlight in the plot.}

\item{highlights.color}{A vector of colors for gene highlights.}

\item{auc.cutoff}{Inserts a vertical line at the cutoff AUC value.}

\item{plot.baseline}{Inserts a vertical line at the baseline AUC value (= AUC of the classifier with basefeatures but no further gene info).}

\item{density.color}{Color data points by density. Default is TRUE.}

\item{density.n}{Set granularity of 2d density color.}

\item{point.scale}{Set point size.}

\item{xlab}{Set label of the x-axis.}

\item{ylab}{Set label of the y-axis.}

\item{linetype}{Set the linetype of the baseline AUC line.}
}
\value{
ggplot object.
}
\description{
This plotting functions creates AUC Scatter plots to visualize Classifier Results.
}
\examples{
\donttest{
  tab <- HetseqClassify(data, trajectories, score.name = "score")
  PlotClassify(tab, highlights=c("MYC", "GAPDH", "ISG15"))
}
}
