% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetseq.R
\name{Hetseq}
\alias{Hetseq}
\title{Heterogeneity-seq wrapper}
\usage{
Hetseq(method = c("test", "classify", "DoubleML"), ...)
}
\arguments{
\item{method}{The method to run Heterogeneity-seq. Calls hetseq.test, hetseq.classify or hetseq.DoubleML.}

\item{...}{Parameters given to the chosen Hetseq method. See respective help pages.}
}
\value{
Table of Heterogeneity-seq results.
}
\description{
Wrapper function for all Heterogeneity-seq functions.
}
\details{
Heterogeneity-seq uses intercellular heterogeneity to identify modulators of cellular response to perturbations. Three approaches to identify these factors are currently available:

- test: Differential Gene Expression testing between cells from two response groups.

- classify: Predicting cellular outcome by expression of single genes (+informative features) reveals genes with strong predictive capabilities (high AUC) as potential pathway modulators.

- DoubleML: A strict predictor that utilizes Causal Inference (DoubleML) to distinguish causal factors from simply correlating genes. Genes with high estimated effects on the outcome and high significance are identified as potential pathway modulators.
}
\examples{
\donttest{

# Full vignette available on https://grandr.erhard-lab.de/articles/web/hetseq.html

  tab <- Hetseq(method="classify", data, trajectories, score.name = "score")
}
}
