% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extreme_input_prep.R
\name{extreme_input_gap}
\alias{extreme_input_gap}
\title{Makes input for Extreme for bimodal analysis.}
\usage{
extreme_input_gap(hm_dir, replicates, timepoints, output_path = "NA")
}
\arguments{
\item{hm_dir}{directory in which all the folders which needs to be processed are}

\item{replicates}{number of replicates in sample}

\item{timepoints}{lists timepoints used in experiments.}

\item{output_path}{directory where the output files will be saved, hm_dir default}
}
\value{
Inputs for extreme for all data prepared.
}
\description{
Makes input for Extreme for bimodal analysis.
}
\examples{
\donttest{
path_to_folders<-system.file("extdata",  package = "HDXBoxeR")

extreme_input_gap(hm_dir =path_to_folders, replicates = 3,
timepoints =c(3, 60, 1800, 72000), output_path=tempdir())
}
}
