% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.asca.R
\name{biplot.asca}
\alias{biplot.asca}
\title{Biplot for ASCA models}
\usage{
\method{biplot}{asca}(
  x,
  factor = 1,
  comps = 1:2,
  xlim = NULL,
  ylim = NULL,
  col = "darkgray",
  expand = 1,
  labels,
  legendpos,
  ...
)
}
\arguments{
\item{x}{\code{asca} object.}

\item{factor}{Factor number or name.}

\item{comps}{\code{integer} vector of selected components.}

\item{xlim}{\code{numeric} vector of length 2 for x-axis limits of the loadings.}

\item{ylim}{\code{numeric} vector of length 2 for y-axis limits of the loadings.}

\item{col}{\code{vector} of colours for score axes and loading axes and points/texts.}

\item{expand}{\code{numeric} expansion for the scores, defaulting to 1.}

\item{labels}{optional. If \code{"names"}, row names are used as labels.
If \code{"numbers"}, row numbers are used as labels. (Can also be a vector of labels.)}

\item{legendpos}{\code{character} position of legend.}

\item{...}{Additional arguments to \code{plot} and \code{scoreplot}.}
}
\value{
No return, only a plot.
}
\description{
Biplot for ASCA models
}
\examples{
# Load candies data
data(candies)

# Basic ASCA model with two factors and interaction
mod <- asca(assessment ~ candy * assessor, data=candies)

# Biplot
biplot(mod)

# Biplot with named loadings
biplot(mod, labels="names")

}
