% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gurobi_numerical_optimization_search.R
\name{resultsGurobiNumericalOptimizeSearch}
\alias{resultsGurobiNumericalOptimizeSearch}
\title{Query the Gurobi Results}
\usage{
resultsGurobiNumericalOptimizeSearch(obj)
}
\arguments{
\item{obj}{The \code{gurobi_numerical_optimization_experimental_design_search} object that is currently running the search}
}
\description{
Returns the results (thus far) of the Gurobi numerical optimization design search
}
\examples{
\dontrun{
if ("gurobi" \%in\% loadedNamespaces()) {
  set.seed(1)
  X = matrix(rnorm(12), nrow = 6)
  gobj = initGurobiNumericalOptimizationExperimentalDesignObject(
    X,
    r = 2,
    num_cores = 1,
    initial_time_limit_sec = 5,
    verbose = FALSE
  )
  res = resultsGurobiNumericalOptimizeSearch(gobj)
  res$obj_vals
}
}
}
\author{
Adam Kapelner
}
