% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_get.R
\name{td_get}
\alias{td_get}
\title{Downloads data of Brazilian government bonds directly from the website}
\usage{
td_get(
  asset_codes = "LTN",
  first_year = 2005,
  last_year = as.numeric(format(Sys.Date(), "\%Y")),
  dl_folder = get_cache_folder()
)
}
\arguments{
\item{asset_codes}{Strings that identify the assets (1 or more assets) in the
names of the excel files. E.g. asset_codes = 'LTN'. When set to NULL, it
will download all available assets}

\item{first_year}{first year of data (minimum of 2015)}

\item{last_year}{first year of data}

\item{dl_folder}{Name of folder to save excel files from tesouro direto (will
create if it does not exists)}
}
\value{
TRUE if successful
}
\description{
This function looks into the tesouro direto website
(https://www.tesourodireto.com.br/) and
downloads all of the files containing prices and yields of government bonds.
You can use input asset_codes to restrict the downloads to specific bonds
}
\examples{
\dontrun{
td_get("LTN", 2020, 2022)
}
}
