% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Simu.R
\name{GRAB.SimuGMatFromGenoFile}
\alias{GRAB.SimuGMatFromGenoFile}
\title{Simulate genotype matrix from external genotype file}
\usage{
GRAB.SimuGMatFromGenoFile(
  nFam,
  nSub,
  FamMode,
  GenoFile,
  GenoFileIndex = NULL,
  SampleIDs = NULL,
  control = NULL
)
}
\arguments{
\item{nFam}{Number of families to simulate.}

\item{nSub}{Number of unrelated subjects to simulate.}

\item{FamMode}{Family structure: "4-members", "10-members", or "20-members".
See Details for pedigree structures.}

\item{GenoFile}{Path to genotype file (passed to \code{\link{GRAB.ReadGeno}}).}

\item{GenoFileIndex}{Index file for genotype data (optional, for BGEN files).}

\item{SampleIDs}{Vector of sample IDs to include (optional).}

\item{control}{List of control parameters passed to \code{\link{GRAB.ReadGeno}}.}
}
\value{
List containing:
\describe{
\item{GenoMat}{Simulated genotype matrix (subjects × variants).}
\item{SubjIDs}{Subject identifiers for simulated samples.}
\item{markerInfo}{Variant information from input file.}
}
}
\description{
Generates genotype matrices for families and unrelated subjects using
haplotype data from existing genotype files. Primarily designed for
rare variant analysis simulations.
}
\details{
This function supports both unrelated and related subjects. Founder genotypes
are sampled from the input genotype file, and offspring genotypes are generated
through Mendelian inheritance.

\strong{Note}: When simulating related subjects, alleles are randomly assigned to
haplotypes during the phasing process.
\subsection{Family Structures:}{
\itemize{
\item \strong{4-members}: Total subjects = nSub + 4×nFam. Structure: 1+2→3+4
\item \strong{10-members}: Total subjects = nSub + 10×nFam.
Structure: 1+2→5+6, 3+5→7+8, 4+6→9+10
\item \strong{20-members}: Total subjects = nSub + 20×nFam.
Structure: 1+2→9+10, 3+9→11+12, 4+10→13+14, 5+11→15+16,
6+12→17, 7+13→18, 8+14→19+20
}
}
}
\examples{
nFam <- 50
nSub <- 500
FamMode <- "10-members"

# PLINK data format. Currently, this function does not support BGEN data format.
PLINKFile <- system.file("extdata", "example_n1000_m236.bed", package = "GRAB")
IDsToIncludeFile <- system.file("extdata", "example_n1000_m236.IDsToInclude", package = "GRAB")

GenoList <- GRAB.SimuGMatFromGenoFile(nFam, nSub, FamMode, PLINKFile,
  control = list(IDsToIncludeFile = IDsToIncludeFile)
)


}
