% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMod.R
\name{runMod}
\alias{runMod}
\alias{runMod,ANY-method}
\title{Runs the model, given the data and treated case (may be a placebo).}
\usage{
runMod(modText, dataBloc, unit, iter = 25000, filepath = NULL)
}
\arguments{
\item{modText}{This is the string that contains your Stan code. Can be written with \code{\link{writeMod}}.}

\item{dataBloc}{This is the data that you pass to the Stan code. It is automatically generated when you run \code{\link{autoConverge}}.}

\item{unit}{The unit of observation to project.}

\item{iter}{The number of iterations you would like to run. Defaults to 25,000.}

\item{filepath}{Your preferred place to save the fit data. See Details.}
}
\value{
The fit for the GPP counterfactual Stan model.
}
\description{
Returns a fit of the Stan model for all observations.
}
\details{
For iterations, check that your model converged (we recommend all r-hats close to 1 and examining traceplots).

We recommend creating a new folder for the file path since the Stan fit creates a large number of files at runtime.
}
\seealso{
\code{\link{plotGPPfit}} \code{\link{writeMod}} \code{\link{GPP}} \code{\link{autoConverge}}
}
\author{
Devin P. Brown \email{devinpbrown96@gmail.com} and David Carlson \email{carlson.david@wustl.edu}
}
