% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accmeasure.R
\name{accmeasure}
\alias{accmeasure}
\title{Accuracy measures}
\usage{
accmeasure(
  y_pred,
  y_true,
  which = c("RMSE", "MSE", "MAPE", "sMAPE", "MAE", "MAD", "MASE")
)
}
\arguments{
\item{y_pred}{fitted values.}

\item{y_true}{observed values.}

\item{which}{one of c("RMSE", "MAPE", "sMAPE", "MAE", "MAD", "MASE")}
}
\value{
The value of the chosen error is returned.
}
\description{
Function that allows to calculate different types of errors for point predictions:
\enumerate{
\item MAE - Mean Absolute Error,
\item MAD - Mean Absolute Deviation,
\item MSE - Mean Squared Error,
\item RMSE - Root Mean Squared Error,
\item MAPE - Mean Absolute Percentage Error,
\item sMAPE - symmetric Mean Absolute Percentage Error,
\item MASE - Mean Absolute Scaled Error (Hyndman & Koehler, 2006)
}
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

accmeasure(fitted(res_gce_package), dataGCE$y, which = "MSE")

}
\references{
Hyndman, R. J., & Koehler, A. B. (2006)
\emph{Another look at measures of forecast accuracy.}
International Journal of Forecasting, 22(4), 679–688.
\doi{10.1016/j.ijforecast.2006.03.001}\cr
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
