#' Fitting GARCHX model for variable selection
#'
#' Fits a GARCHX model with given data and estimates the coefficients for omega, alpha, beta, and pi
#'
#' @param eps Time series
#' @param X Matrix with exogenous covariates where the number of rows is equal to the length of eps
#' @param order Order of the GARCH model. Value of p cannot be 0
#' @param delta Value of the power of the main time series to allow for Power GARCHX, default is 2 for GARCHX
#' @param optim.method Optimization method for maximizing quasi-likelihood function. Options: "NR", "L-BFGS-B", "GA", "PS", "SA". Default value is "NR"
#'
#' @details Uses the GARCHX model \deqn{\mathcal{E}_t = \sigma_tw_t}
#' \deqn{\sigma^2_t = \omega_0 + \sum^{p}_{i=1}\alpha_i\mathcal{E}_{t-i}^2 + \sum^q_{j=1}\beta_j\sigma^2_{t-j}+\mathbf{\pi}^T\mathbf{x}_{t-1}}
#'
#' To estimate the coefficients for \deqn{\omega, \alpha, \beta, \pi}.
#' No variable selection is done in this function.
#'
#' @return An object of class GARCHX
#' @export
#'
GARCHX <- function(eps, X, order = c(1, 1), delta = 2, optim.method = "NR"){
  # High level/interface function for GARCHX.default function
  # Calling GARCHX.default function
  UseMethod("GARCHX")
}
