% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.random.R
\name{is.random}
\alias{is.random}
\title{Check if a factor is random}
\usage{
is.random(x)
}
\arguments{
\item{x}{a vector of data, usually a nominal variable encoded as a \code{"random factor"} using \code{\link{as.random}}.}
}
\value{
Function \code{is.random} returns \code{TRUE} or \code{FALSE} depending on whether its argument is a random factor or not.
}
\description{
This function works the same way as \code{\link{is.factor}}.
}
\examples{
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
is.fixed(CG)
is.random(MQ)
}
\seealso{
\code{\link{is.fixed}}, \code{\link{as.random}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
