% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarityMatrix.R
\name{similarityMatrix}
\alias{similarityMatrix}
\title{Calculate the similarity matrix}
\usage{
similarityMatrix(
  file = NA,
  mibs.file = NA,
  pairs.file = NA,
  ped.file = NA,
  group = NA,
  plots = TRUE,
  similarity = 0.85,
  verbose = TRUE,
  verbosity = 1
)
}
\arguments{
\item{file}{Input file path. Default: NA.}

\item{mibs.file}{MIBS input file path. Default: NA.}

\item{pairs.file}{PAIRS input file path. Default: NA.}

\item{ped.file}{PED input file path. Default: NA.}

\item{group}{Sample identifier for statistics. Default: NA.}

\item{plots}{Should plots be created? Default: TRUE.}

\item{similarity}{Similarity threshold. Default: 0.85.}

\item{verbose}{Should output be verbose? Default: TRUE.}

\item{verbosity}{Verbosity level. Default: 1.}
}
\value{
Does not return a value. Creates output files in the same directory as the input files.
}
\description{
Performs pairwise similarity analysis on genotypic data.
}
\details{
Reads genotype data, performs pairwise similarity calculations, generates plots, and outputs data for further analysis.
}
\examples{
\dontrun{
     similarityMatrix(file = file.path(outdir, "example_data.csv.GOOD"))
}

}
