% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainbow3D.R
\name{rainbow3D}
\alias{rainbow3D}
\title{3D Rainbow Plot for Functional Time Series}
\usage{
rainbow3D(f_data)
}
\arguments{
\item{f_data}{A \eqn{J \times N} matrix of functional time series data, where \eqn{J} is the number of discrete points in the grid and \eqn{N} is the sample size.}
}
\value{
A 3D rainbow plot of the functional time series data.
}
\description{
This function creates a 3D rainbow plot of a functional time series (FTS) using the \code{rgl} package.
The data is color-coded using a rainbow color scheme, with earlier curves in red and later curves in violet.
A 360-degree interactive view is available through an embedded widget.
}
\examples{
\donttest{
data(Spanish_elec) # Daily Spanish electricity price profiles
rainbow3D(Spanish_elec)

data(sp500) # S&P500 index data
rainbow3D(OCIDR(sp500))
}
}
