% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{LasVegas}
\alias{LasVegas}
\title{Las Vegas}
\usage{
LasVegas(start = NULL, K = 50, verbose = FALSE)
}
\arguments{
\item{start}{Binary vector with the set of initial features (1: selected and 0: unselected) for the algorithm}

\item{K}{The maximum number of iterations without improvement to finalize the algorithm}

\item{verbose}{Print the partial results in each iteration}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on Las Vegas algorithm. This function is called internally within the \code{\link{searchAlgorithm}} function. The LasVegas method  \insertCite{LiuSetiono1996}{FSinR} starts with a certain set of features and in each step a new set is randomly generated, if the new set is better it is saved as the best solution. The algorithm ends when there are no improvements in a certain number of iterations.
}
\examples{
\donttest{
## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space 

## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function with Las Vegas
LV_search <- LasVegas()

# Performs the search process directly (parameters: dataset, target variable and evaluator)
LV_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
