% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FGLMtrunc.R
\name{fglm_trunc}
\alias{fglm_trunc}
\title{Fit a truncated Functional Generalized Linear Model}
\usage{
fglm_trunc(
  Y,
  X.curves,
  S = NULL,
  grid = NULL,
  family = c("gaussian", "binomial"),
  degree = 3,
  nbasis = NULL,
  knots = NULL,
  nlambda.s = 10,
  lambda.s.seq = NULL,
  precision = 1e-05,
  parallel = FALSE
)
}
\arguments{
\item{Y}{\code{n}-by-\code{1} vector of response.
Each row is an observed scalar response, which is continous for family="gaussian" and binary (i.e. 0 and 1) for family="binomal".}

\item{X.curves}{\code{n}-by-\code{p} matrix of functional predictors.
Each row is an observation vector at \code{p} finite points on \code{[0,T]} for some \code{T>0}.}

\item{S}{(optional) \code{n}-by-\code{s} matrix of scalar predictors. Binary variable should be coded as numeric rather than factor.}

\item{grid}{A sequence of \code{p} points at which \code{X} is recorded, including both boundaries \code{0} and \code{T}. If not
specified, an equally spaced sequence of length p between 0 and 1 will be used.}

\item{family}{Choice of exponential family for the model. The function then uses corresponding canonical link function to fit model.}

\item{degree}{Degree of the piecewise polynomial. Default 3 for cubic splines.}

\item{nbasis}{Number of B-spline basis.
If \code{knots} is unspecified, the function choose \code{nbasis - degree - 1} \strong{internal} knots at suitable quantiles of \code{grid}.
If \code{knots} is specified, the value of \code{nbasis} will be \strong{ignored}.}

\item{knots}{\code{k} \strong{internal} breakpoints that define that spline.}

\item{nlambda.s}{(optional) Length of sequence of smoothing regularization parameters. Default 10.}

\item{lambda.s.seq}{(optional) Sequence of smoothing regularization parameters.}

\item{precision}{(optional) Error tolerance of the optimization. Default 1e-5.}

\item{parallel}{(optional) If TRUE, use parallel \code{foreach} to fit each value of \code{lambda.s.seq}. Must register parallel before hand, such as doMC or others.}
}
\value{
A list with components:
\item{grid}{The \code{grid} sequence used.}
\item{knots}{The \code{knots} sequence used.}
\item{degree}{The degree of the piecewise polynomial used.}
\item{eta.0}{Estimate of B-spline coefficients \eqn{\eta} \strong{without} truncation penalty.}
\item{beta.0}{Estimate of functional parameter \eqn{\beta} \strong{without} truncation penalty.}
\item{eta.truncated}{Estimate of B-spline coefficients \eqn{\eta} \strong{with} truncation penalty.}
\item{beta.truncated}{Estimate of functional parameter \eqn{\beta} \strong{with} truncation penalty.}
\item{lambda.s0}{Optimal smoothing regularization parameter \strong{without} truncation chosen by GCV.}
\item{lambda.s}{Optimal smoothing regularization parameter \strong{with} truncation chosen by BIC.}
\item{lambda.t}{Optimal truncation regularization parameter chosen by BIC.}
\item{trunc.point}{Truncation point \eqn{\delta} where \eqn{\beta(t)} = 0 for \eqn{t \ge \delta}.}
\item{alpha}{Intercept (and coefficients of scalar predictors if used) of truncated model.}
\item{scalar.pred}{Logical variable indicating whether any scalar predictor was used.}
\item{call}{Function call of fitted model.}
\item{family}{Choice of exponential family used.}
}
\description{
Fit a truncated functional linear or logistic regression model using nested group lasso penalty.
The solution path is computed efficiently using active set algorithm with warm start. Optimal tuning parameters (\eqn{\lambda_s, \lambda_t})
are chosen by Bayesian information criterion (BIC).
}
\details{
\subsection{Details on spline estimator}{

For an order \code{q} B-splines (\code{q = degree + 1} since an intercept is used) with \code{k} internal knots 0 < \code{t_1} <...< \code{t_k} < T,
the number of B-spline basis equals \code{q + k}. Without truncation (\eqn{\lambda}_t=0), the function returns smoothing estimate that is
equivalent to the method of Cardot and Sarda (2005), and optimal smoothing parameter is chosen by Generalized Cross Validation (GCV).
}

\subsection{Details on \code{family}}{

The model can work with Gaussian or Bernoulli responses. If \code{family="gaussian"}, identity link is used. If \code{family="binomial"}, logit link is used.
}

\subsection{Details on scalar predictors}{

\code{FGLMtrunc} allows using scalar predictors together with functional predictors. If scalar predictors are used, their estimated coefficients
are included in \code{alpha} form fitted model.
}
}
\examples{

# Gaussian response
data(LinearExample)
Y_linear = LinearExample$Y
Xcurves_linear = LinearExample$X.curves
fit1 = fglm_trunc(Y_linear, Xcurves_linear, nbasis = 20, nlambda.s = 1)
print(fit1)
plot(fit1)

}
\references{
Xi Liu, Afshin A. Divani, and Alexander Petersen. "Truncated estimation in functional generalized linear regression models" (2022). \emph{Computational Statistics & Data Analysis}.

Hervé Cardot and Pacal Sarda. "Estimation in generalized linear models for functional data via penalized likelihood" (2005). \emph{Journal of Multivariate Analysis}.
}
\seealso{
\link[splines2]{bSpline} from \link[splines2]{splines2} R package for usage of B-spline basis.
}
