% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alts.R
\name{alts}
\alias{alts}
\title{Using the basic idea of least trimmed square to detect and remove outliers before estimating the coefficients.
Adaptive least trimmed square.}
\usage{
alts(x, y, alpha1 = 0.1, alpha2 = 1.5, k = 6, nn = TRUE,
  intercept = TRUE)
}
\arguments{
\item{x}{input matrix of predictors with n rows and p columns.}

\item{y}{input vector of dependent variable with length n.}

\item{alpha1}{parameter used to adjust the upper bound of outliers. Take value from 0 to 1, default 0.1.}

\item{alpha2}{parameter used to adjust the lower bound of outliers. Take value larger than 1, default 1.5.}

\item{k}{parameter used to determine the boundary of outliers in the following step of algorithm. Take value from 1 to 10, default 6.}

\item{nn}{whether coefficients are non-negative,default TRUE.}

\item{intercept}{whether intercept is included in model, default TRUE.}
}
\value{
beta:  estimation of coefficients.

number_outlier: number of outliers.

outlier_detect:  index of detected outliers.

X.new:  good observed points for independent variables.

Y.new:  good observed points for dependent variables.

k:  modified k (if the input value is not appropriate).
}
\description{
Using the basic idea of least trimmed square to detect and remove outliers before estimating the coefficients.
Adaptive least trimmed square.
}
\examples{
library(FARDEEP)
samp = sample.sim(n = 500, p = 20, sig = 1, a1 = 0.1, a2 = 0.2, nn = TRUE, intercept = TRUE)
result = alts(samp$x, samp$y, alpha1 = 0.1, alpha2 = 1.5, k = 6, nn = TRUE, intercept = TRUE)
coef = result$beta
}
\references{
Yuning Hao, Ming Yan, Blake R. Heath, Yu L. Lei and Yuying Xie. Fast and Robust Deconvolution of Tumor Infiltrating Lymphocyte from Expression Profiles using Least Trimmed Squares. <doi:10.1101/358366>
}
\author{
Yuning Hao, Ming Yan, Blake R. Heath, Yu L. Lei and Yuying Xie
}
