% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{summary.lmFAB}
\alias{summary.lmFAB}
\title{Summarizing Linear Model Fits with FAB Inference}
\usage{
\method{summary}{lmFAB}(object, correlation = FALSE,
  symbolic.cor = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{lmFAB}}

\item{correlation}{see \code{summary.lm}}

\item{symbolic.cor}{see \code{summary.lm}}

\item{...}{see \code{summary.lm}}
}
\value{
A list of summary statistics of the fitted linear model
}
\description{
\code{summary} method for class \code{lmFAB}
}
\details{
A mod of \code{summary.lm} that shows FAB p-values in table
}
\examples{

# n observations, p FAB variables, q=2 control variables 

n<-100 ; p<-25 

# X is design matrix for params of interest
# beta is vector of true parameter values 
# v a variable in the linking model - used to share info across betas

v<-rnorm(p) ; beta<-(2 - 2*v + rnorm(p))/3 ; X<-matrix(rnorm(n*p),n,p)/8

# control coefficients and variables  
alpha1<-.5 ; alpha2<- -.5
w1<-rnorm(n)/8
w2<-rnorm(n)/8

# simulate data 
lp<-1 + alpha1*w1 + alpha2*w2 + X\%*\%beta 
y<-rnorm(n,lp) 

# fit model
fit<-lmFAB(y~w1+w2,X,~v)

fit$FABpv
fit$FABci 
summary(fit) # look at p-value column 


}
