\name{fitdGPD}
\alias{fitdGPD}
\title{Maximum likelihood estimation of the parameters of the discrete generalized Pareto distribution}
\usage{
fitdGPD(excess, alpha = 0.05)
}
\arguments{
\item{excess}{vector of positive exceedances, i.e., \eqn{Y - t \mid Y > t}, with \eqn{t} being the threshold}

\item{alpha}{level for confidence interval of scale and shape parameters. Default: 0.05, giving 95\% confidence intervals}
}
\value{
a list with elements
\itemize{
\item \code{mle} vector of dimension 2 containing estimated scale and shape parameters
\item \code{CI} matrix of dimension 2 by 2 containing the \eqn{1-\alpha} level confidence intervals for scale and shape
}
}
\description{
Given a sample of exceedances, estimate the parameters via maximum likelihood along with \eqn{1-\alpha} level confidence intervals.
}
\examples{
fitdGPD(rpois(1000,2))
}
\references{
Hitz, A.S., G. Samorodnistsky and R.A. Davis (2024). Discrete Extremes, \emph{Journal of Data Science}, 22(\bold{4}), pp. 524-536.
}
