% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_design.R
\name{search_design}
\alias{search_design}
\title{Search Full Factorial for Fractional Factorial Design}
\usage{
search_design(full_factorial, fractional_factorial_design)
}
\arguments{
\item{full_factorial}{a `data.table` generated by the `full_factorial` function}

\item{fractional_factorial_design}{a means of creating a fractional design using either orthogonal arrays or Federov. See the tutorial for examples.}
}
\value{
a `data.frame` with only the rows of your chosen fractional factorial design.
}
\description{
Returns a consistent fractional factorial design from the input fractional factorial design. The key advantage of this function is that it ensures factors are coded and enchances the attributes of the output.
}
\examples{
# The use of this function depends on what the input to the argument fractional_factorial_design
# will be. See Step 4 of Practical Introduction to ExpertChoice vignette.

# Step 1
attrshort  = list(condition = c("0", "1", "2"),
technical =c("0", "1", "2"),
provenance = c("0", "1"))

#Step 2
# ff stands for "full fatorial"
 ff  <-  full_factorial(attrshort)
 af  <-  augment_levels(ff)
# af stands for "augmented factorial"

# Step 3
# Choose a design type: Federov or Orthogonal. Here an Orthogonal one is used.
nlevels <- unlist(purrr::map(ff, function(x){length(levels(x))}))
fractional_factorial <- DoE.base::oa.design(nlevels = nlevels, columns = "min34")

# Step 4! - The search_design function.
# The functional draws out the rows from the original augmented full factorial design.
colnames(fractional_factorial) <- colnames(ff)
fractional <- search_design(ff, fractional_factorial)
}
