% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDEdata.R
\name{GetDEdata}
\alias{GetDEdata}
\title{Get the results of differential expression analysis.}
\usage{
GetDEdata(
  P1_count,
  P2_count,
  F1_count,
  output_type,
  type,
  homoeologs,
  count_threshold = 5
)
}
\arguments{
\item{P1_count}{A data frame. The count table of genes in P1 species. For the count table, the first column is the gene identifier, and other columns are the corresponding expression levels of the genes in each biological replicate.}

\item{P2_count}{A data frame. The count table of genes in P2 species.}

\item{F1_count}{A data frame. The count table of genes in F1 species.}

\item{output_type}{A character. "F1_vs_P1", "F1_vs_P2" or "P2_vs_P1".}

\item{type}{A character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes in the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{count_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 5 (the count values in all replicates).}
}
\value{
A data frame. Differential expression analysis results.
}
\description{
Extract the results of differential expression analysis.
}
\details{
F1_vs_P1: Results of differential expression analysis using DESeq2. Parental P1 was used as the control group and F1 was used as the treatment group. If the log2FoldChange of a gene is positive, it means that the expression level of the gene in F1 is higher than that in P1. F1_vs_P2: Results of differential expression analysis using DESeq2. Parental P2 was used as the control group and F1 was used as the treatment group. P2_vs_P1: Results of differential expression analysis using DESeq2. Parental P1 was used as the control group and P2 was used as the treatment group.
}
\examples{
\donttest{
P2_vs_P1 <- GetDEdata(P1_count = P1_miRNA_count,
                      P2_count = P2_miRNA_count,
                      F1_count = F1_miRNA_count,
                      output_type = "P2_vs_P1", type="sRNA")
}
}
