% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chen_2016_event_time_abovetime0.R
\name{Chen_2016_event_time_abovetime0}
\alias{Chen_2016_event_time_abovetime0}
\title{Function to generate event time based on Chen 2016 method for ongoing subject}
\usage{
Chen_2016_event_time_abovetime0(u, distribution, p, time0, a, b, mu, sd)
}
\arguments{
\item{u}{a scalar with between 0 and 1}

\item{distribution}{the distribution for the control arm, valid values of inputs include: exponential, weibull, log-normal, log-logistic}

\item{p}{the proportion of cured population in the control arm}

\item{time0}{the observed ongoing survival time}

\item{a}{the shape parameter in the Weibull or the log-logistic distribution}

\item{b}{the scale parameter in the exponential, Weibull or the log-logistic distribution}

\item{mu}{the mean in the log-normal distribution}

\item{sd}{the standard deviation in the log-normal distribution}
}
\value{
the event time
}
\description{
generate event time under the delay-treatment effect and cured population setting given T>time0
}
\references{
\itemize{
\item Chen, Tai-Tsang. "Predicting analysis times in randomized clinical trials with cancer immunotherapy."
BMC medical research methodology 16.1 (2016): 1-10.
}
}
