% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmfWrapper.R
\name{nmfCluster}
\alias{nmfCluster}
\title{Non-negative matrix factorization (NMF)}
\usage{
nmfCluster(data = NULL, rank = NULL)
}
\arguments{
\item{data}{A Data set}

\item{rank}{Specification of the factorization rank}
}
\value{
A list of cluster labels, a R object of class "nmf" and the centers of the clusters
}
\description{
This function factorizes samples matrix into (usually) two matrices W the cluster centroids
 and H the cluster membership,
}
\examples{
library(datasets)
data(iris)

rndSamples <- sample(nrow(iris),100)
trainData <- iris[rndSamples,]
testData <- iris[-rndSamples,]

cls <- nmfCluster(trainData[,1:4],rank=3)
}
