% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_value.R
\encoding{UTF-8}
\name{expected_value}
\alias{expected_value}
\title{Expected value of a given function for any distribution}
\usage{
expected_value(f, parameters, support, g = identity, routine = NULL, ...)
}
\arguments{
\item{f}{a character with the probability density/mass function name. The
function must be availble in the \code{R} environment using the
usual nomenclature (\code{d} prefix before the name).}

\item{parameters}{a list with the input parameters for the distribution.}

\item{support}{a list with the following entries:
\itemize{
\item \code{interval}: a two dimensional atomic vector
indicating the set of possible values of a random variable
having the distribution specified in \code{y_dist}.
\item \code{type}: character indicating if distribution has a
\code{discrete} or a \code{continous} random variable.
}}

\item{g}{a given function \eqn{g(x)}. If \code{g = identity}, then
\eqn{g(x) = x} and this is actually the mean of the distribution.}

\item{routine}{a character specifying the integration routine.
\code{integrate} and \code{gauss_quad} are available for
continuous distributions, and \code{summate} for discrete ones.
Custom routines can be defined but they must be compatible
with the \code{\link{integration}} API.}

\item{...}{further arguments for the integration routine.}
}
\value{
the expected value of the specified distribution.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes the name of a probability density/mass function as an
argument and creates a function to compute the expected value.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example 1: mean of X ~ N(2, 1) using 'integrate' under the hood.
support <- list(interval=c(-Inf, Inf), type = "continuous")

expected_value(
  f = "dnorm",
  parameters = list(mean = 2, sd = 1),
  support = support
)

# Equivalent to
expected_value(
  f = "dnorm",
  parameters = list(mean = 2, sd = 1),
  support = support,
  g = identity,
  routine = "integrate"
)

# Example 1: mean of X ~ N(22, 1)

# 'integrate' fails because the mean is 22.
expected_value(
  f = "dnorm",
  parameters = list(mean = 22, sd = 1),
  support = support
)

# Let's compute with Monte Carlo integration
expected_value(
  f = "dnorm",
  parameters = list(mean = 22, sd = 1),
  support = support,
  routine = "monte-carlo"
)

# Compute Monte Carlo integration with more samples
\donttest{
expected_value(
  f = "dnorm",
  parameters = list(mean = 22, sd = 1),
  support = support,
  routine = "monte-carlo",
  n = 1e8
)
}

#----------------------------------------------------------------------------

}
\seealso{
Other distributions utilities: 
\code{\link{cum_hazard_fun}()},
\code{\link{hazard_fun}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{distributions utilities}
