% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram.R
\name{svdgram}
\alias{svdgram}
\title{Compute Phylogenetic Trees Using an n-Gram and SVD Approach}
\usage{
svdgram(matrix, rank, species, SVS = TRUE)
}
\arguments{
\item{matrix}{either a dataframe or a matrix where each row represents a property of a protein (for instance, the frequencies of tetrapeptides) and each column represents a different protein (or species).}

\item{rank}{a numeric array providing the ranks that want to be used to approach the data matrix using SVD.}

\item{species}{character array providing the species' names.}

\item{SVS}{logical. When the matrix passed as argument correspond to the peptide-protein matrix and SVS is set to TRUE, then the function will compute a matrix where the columns are the Species Vector Sums. Alternatively, if the matrix passed as argument is already a matrix where the columns encode for species, SVS should be set to FALSE.}
}
\value{
An object of class multiPhylo containing a tree for each rank value required.
}
\description{
Computes phylogenetic trees using an n-gram and SVD approach.
}
\details{
When the matrix passed as argument is a matrix of peptide-protein, the function implement the method described by Stuart et al. 2002 (see references).
}
\examples{
a <- ngraMatrix(bovids[, 1:4], k = 2)[[2]][, -1]
species <- names(a)
svdgram(matrix = a, rank = 4, species = species, SVS = FALSE)
}
\references{
Stuart et al. Bioinformatics 2002; 18:100-108.
}
\seealso{
ngraMatrix()
}
