% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expy.r
\name{expy}
\alias{expy}
\title{Compute the expy index of regions from regions - industries matrices}
\usage{
expy(mat, vec)
}
\arguments{
\item{mat}{An incidence matrix with regions in rows and industries in columns}

\item{vec}{A vector that gives GDP, R&D, education or any other relevant regional attribute that will be used to compute the weighted average for each industry}
}
\value{
A numeric vector representing the expy index of regions computed from the regions - industries matrix
}
\description{
This function computes the expy index of regions from (incidence) regions - industries matrices, as proposed by Hausmann, Hwang & Rodrik (2007). The index is a measure of the productivity level associated with a region's specialization pattern.
}
\examples{
## generate a region - industry matrix
set.seed(31)
mat <- matrix(sample(0:100, 20, replace = TRUE), ncol = 4)
rownames(mat) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c("I1", "I2", "I3", "I4")

## a vector of GDP of regions
vec <- c(5, 10, 15, 25, 50)
## run the function
expy(mat, vec)
}
\references{
Balassa, B. (1965) Trade Liberalization and Revealed Comparative Advantage, \emph{The Manchester School} \strong{33}: 99-123 \cr
\cr
Hausmann, R., Hwang, J. & Rodrik, D. (2007) What you export matters, \emph{Journal of economic growth} \strong{12}: 1-25.
}
\seealso{
\code{\link{location_quotient}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{diversity}
\keyword{specialization}
