% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_impute_env_values.R
\name{ec_impute_env_values}
\alias{ec_impute_env_values}
\title{Impute Environmental Variables using Mean Values of occurrences within a certain radius}
\usage{
ec_impute_env_values(
  data_x,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude",
  radius_km = 10,
  iter = 3
)
}
\arguments{
\item{data_x}{this is data_x which is the output of ec_extract_env_layers}

\item{latitude}{default set to "decimalLatitude"}

\item{longitude}{default set to "decimalLongitude"}

\item{radius_km}{radius to average the values of data points within the circle to imput the values for missing datta points}

\item{iter}{number of times to iterate the imputation, e.g. 1 or 2 or 3}
}
\value{
An updated table of data_x which has imputed values for the missing env variables, condition applies that the this imputation wont work if the data points are too sparse.
}
\description{
Impute Environmental Variables using Mean Values of occurrences within a certain radius
}
\examples{

data_x <- data.frame(
  scientificName = "Mexacanthina lugubris",
  decimalLongitude = c(-117, -117.8, -116.9),
  decimalLatitude = c(32.9, 33.5, 31.9),
  BO_sstmean = c(12, NA, 14),
  BO_sstmin = c(9, NA, 10),
  BO_sstmax = c(14, NA, 18)
)
radius_km <- 10
iter <- 3
data_x <- ec_impute_env_values(data_x,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude",
  radius_km, iter
)

}
