% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_flag_with_locality.R
\name{ec_flag_with_locality}
\alias{ec_flag_with_locality}
\title{Filter records to georeference using GEOLocate}
\usage{
ec_flag_with_locality(
  data,
  uncertainty = "coordinateUncertaintyInMeters",
  locality = "locality",
  verbatimLocality = "verbatimLocality"
)
}
\arguments{
\item{data}{data table with occurrence information}

\item{uncertainty}{Mendatory to have coordinateUncertaintyInMeters column in the data table}

\item{locality}{Mandatory to have locality column in the data table.}

\item{verbatimLocality}{Mandatory to have verbatimLocality in the data table.}
}
\value{
A column with flagged records as 1, which means these records has potential to be georeferenced.
}
\description{
Filter records to georeference using GEOLocate
}
\details{
Records those does not have coordinates assigned but has locality and varbatim locality information to assign coordinates by using external tools such as GEOLocate
}
\examples{
data <- data.frame(
  coordinateUncertaintyInMeters = c(NA, "N/A", 50, "30", NA, "N/A", NA),
  locality = c("Santa Cruz", NA, "Los Angeles", "N/A", "", "San Diego", NA),
  verbatimLocality = c(NA, "CA coast", "", "N/A", "Long Beach", NA, "")
)
data$flag_check_geolocate <- ec_flag_with_locality(
data, uncertainty = "coordinateUncertaintyInMeters",
locality = "locality",
verbatimLocality = "verbatimLocality"
)

}
