% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setSelectNeutral}
\alias{setSelectNeutral}
\title{Setting the selection}
\usage{
setSelectNeutral(genomeObj)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}
}
\value{
a \code{Selection} object
}
\description{
Generation of a neutral class \code{Selection} object. It can be used as a
basis for adding selection layers with the \code{setSelectOnInds},
\code{setSelectOnGametes} or \code{setSelectOnGametesProd} functions, or
if the model is neutral.
}
\details{
An object of type \code{Selection} is an object which describes the set of
fitnesses which will be taken into account in the simulations. The
selection according to these fitnesses can be applied at three levels:
at the level of the individual, at the level of the production of
gametes and at the level of the gametes themselves.
Selection is therefore genotypic in the first two cases (each genotype
is associated with a fitness value) and haplotypic in the third (each
haplotype is associated with a fitness value).
}
\examples{
### Example with two loci, each with two alleles ###
# Definition of the diploid locus
DL <- list(dl = c("A", "a"))
# Definition of the haploid locus
HL <- list(hl = c("B", "b"))
# Definition of the object of Genome class
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = DL)
genomeObj

### Exemple with more diploid loci ###
# Definition of the diploid loci
DL <- list(
  dl1 = c("A", "a"),
  dl2 = c("B", "b"),
  dl3 = c("C", "c")
)
# Definition of the haploid locus
HL <- list(hl = c("D", "d"))
# Definition of the object of Genome class, with in addition the necessary
# definition of recombination rates between loci:
genomeObj <- setGenome(
  listHapLoci = HL, listDipLoci = DL,
  recRate = c(0.1, 0.5)
)
# Here we have a 0.1 recombination rate between dl1 and dl2 and a 0.5
# recombination rate between dl2 and dl3. It is as if dl1 and dl2 were linked,
# for example on the same chromosome, and that dl2 (and dl1 by consequence)
# and dl3 were independent, for example on different chromosomes.

genomeObj

}
\author{
Ehouarn Le Faou
}
