% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EXRQ.R
\name{testC.EVI}
\alias{testC.EVI}
\title{Testing the Constancy of EVI Over Covariates}
\usage{
testC.EVI(y, x, grid.lam = seq(-2, 2, 0.1), grid.k, tau.lam = 0.9,
  u.x = 0, a = 0, M = 2, tol = 1e-04)
}
\arguments{
\item{y}{a vector of n untransformed responses}

\item{x}{a n x p matrix of n observations and p predictors}

\item{grid.lam}{a grid of points for power-transformation parameter}

\item{grid.k}{a grid of points for k, the number of upper order statistics involved in Hill estimator}

\item{tau.lam}{the quantile level used for estimating the transformation parameter}

\item{u.x}{the proportion to be trimmed in the x direction}

\item{a}{location shift parameter in the power transformation (introduced to avoid negative y values)}

\item{M}{a constant larger than one that is used for estimating the c vector and thus K(x) function. The default is two}

\item{tol}{the tolerance level for checking quantile crossing issue}
}
\value{
A list is returned with the following components

lam: the estimated power-transformation parameter

k: the selected tuning parameter k, the number of upper order statistics involved in Hill estimator

Tm: the proposed test statistic

scaledTm: the standardized test statistic

pval.iid: the p-value based on iid assumption, that is, assuming that K(x)=1

pval.nid: the p-value based on estimated K(x)=(X'C)^(1/EVI)

gamma.bar: the pooled EVI estimator

hat.gamma: a N-dimensional vector consisting of the estimated x-dependent EVI at x=xstar

xstar: a N x p matrix of N observations and p predictors
}
\description{
This function tests whether the extreme value index of Y, gamma(x), is constant or varying across the covariate x by using the test procedure
described in Section 3.4 of Wang and Li (2013).
}
\examples{
library(EXRQ)
n=500
tau.e = c(0.99, 0.993, 0.995)
set.seed(12368819)
x1 = runif(n, -1, 1)
x2 = runif(n, -1, 1)
sqrty = 2 + x1 + x2 + (1+0.8*x1)*rpareto(n, 0.5)
x = as.matrix(cbind(x1, x2))
y = sqrty^2
out = testC.EVI(y, x, grid.lam=seq(-0.5, 1.5, 0.1), grid.k=50, tau.lam=0.9)
(Tval = out$scaledTm)
(pval.iid = out$pval.iid)
(pval.nid = out$pval.nid)
}
\references{
Wang, H. and Li, D. (2013). Estimation of conditional high quantiles through power transformation. Journal of the American Statistical Association, 108, 1062-1074.
}

