% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffsql.R
\name{write.dbi.ffdf}
\alias{write.dbi.ffdf}
\title{Write ffdf data to a database table by using a DBI connection.}
\usage{
write.dbi.ffdf(
  x,
  name,
  dbConnect.args = list(drv = NULL, dbname = NULL, username = "", password = ""),
  RECORDBYTES = sum(.rambytes[vmode(x)]),
  BATCHBYTES = getOption("ffbatchbytes"),
  by = NULL,
  VERBOSE = FALSE,
  ...
)
}
\arguments{
\item{x}{the \code{\link[ff]{ffdf}} to write to the database}

\item{name}{character string with the name of the table to store the data in. Passed on to \code{\link[DBI]{dbWriteTable}}.}

\item{dbConnect.args}{a list of arguments to pass to DBI's \code{\link[DBI]{dbConnect}} (like drv, dbname, username, password). See the examples.}

\item{RECORDBYTES}{optional integer scalar representing the bytes needed to process a single row of the ffdf}

\item{BATCHBYTES}{integer: bytes allowed for the size of the data.frame storing the result of reading one chunk. 
See documentation in \code{\link[ff]{read.table.ffdf}} for more details.}

\item{by}{integer passed on to \code{\link[bit]{chunk}} indicating to write to the database in chunks of this size. Overwrites
the behaviour of BATCHBYTES and RECORDBYTES.}

\item{VERBOSE}{logical: TRUE to verbose timings for each processed chunk (default FALSE).}

\item{...}{optional parameters passed on to \code{\link[DBI]{dbWriteTable}}}
}
\value{
invisible()
}
\description{
Write \code{\link[ff]{ffdf}} data to a database table by using a DBI connection.
This can for example be used to store large ffdf datasets from R in
Oracle, SQLite, MySQL, PostgreSQL, Hive or other SQL databases. \cr
Mark that for very large datasets, these SQL databases might have tools to speed up by bulk loading.
You might also consider that as an alternative to using this procedure.
}
\details{
Opens up the DBI connection using \code{DBI::dbConnect}, writes data to the SQL table
using \code{DBI::dbWriteTable} by extracting the data in batches from the \code{\link[ff]{ffdf}}
and appending them to the table.
}
\examples{
require(ff)
require(DBI)

##
## Example query using data in sqlite
##
require(RSQLite)
dbfile <- system.file("smalldb.sqlite3", package="ETLUtils")
drv <- dbDriver("SQLite")
query <- "select * from testdata limit 10000"
x <- read.dbi.ffdf(query = query, dbConnect.args = list(drv = drv, dbname = dbfile), 
first.rows = 100, next.rows = 1000, VERBOSE=TRUE)

## copy db in package folder to temp folder as CRAN does not allow writing in package dirs
dbfile <- tempfile(fileext = ".sqlite3")
file.copy(from = system.file("smalldb.sqlite3", package="ETLUtils"), to = dbfile)
Sys.chmod(dbfile, mode = "777")
write.dbi.ffdf(x = x, name = "helloworld", row.names = FALSE, overwrite = TRUE,
  dbConnect.args = list(drv = drv, dbname = dbfile), 
  by = 1000, VERBOSE=TRUE)
test <- read.dbi.ffdf(query = "select * from helloworld", 
  dbConnect.args = list(drv = drv, dbname = dbfile))

## clean up for CRAN
file.remove(dbfile)
\dontrun{
require(ROracle)
write.dbi.ffdf(x = x, name = "hellooracle", row.names = FALSE, overwrite = TRUE,
  dbConnect.args = list(drv = dbDriver("Oracle"), 
                        user = "YourUser", password = "YourPassword", dbname = "Mydatabase"), 
  VERBOSE=TRUE)
}
}
\seealso{
\code{\link[DBI]{dbWriteTable}}, \code{\link[bit]{chunk}}
}
