% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_background_earthquakes.R
\name{simulate_background_earthquakes}
\alias{simulate_background_earthquakes}
\title{Simulate a catalog of background earthquakes}
\usage{
simulate_background_earthquakes(earthquake_data_plus)
}
\arguments{
\item{earthquake_data_plus}{An object of data.frame with 7 columns: date, time,
longitude, latitude, magnitude, bandwidth, and probability, in this order and
in a consistent format for the first 5 columns.
The columns bandwidth and probability are two numeric vectors.
The column bandwidth records the smoothness
bandwidths used in variable kernel estimation and the column probability contains
the probability for each earthquake in the catalog of interest (observed earthquakes)
to be a background event; see the \link[ETAS]{etas} function in the ETAS package (Jalilian, 2019) and
the articles of Zhuang et al. (2002, 2004).}
}
\value{
background_catalog: An object of data.frame with 5 columns: date,
  time, longitude, latitude, and magnitude of the simulated background earthquakes,
  in this order and a consistent format.
}
\description{
In fitting the ETAS model to the earthquake data catalog of
  interest (\bold{earthquake_data}), the background intensity function \eqn{{\mu}}
  is estimated. This function performs a simulation
  of background events based on the estimate \eqn{\hat{{\mu}}}.
  The time period for the simulated background catalog is consistent with
  that of \bold{earthquake_data}.
}
\examples{
set.seed(1)
simulate_background_earthquakes(VCI_earthquakes_plus)


}
\references{
Dutilleul, P., Genest, C., Peng, R., 2024. Bootstrapping for parameter uncertainty
 in the space-time epidemic-type aftershock sequence model. Geophysical Journal 
 International 236, 1601–1608. 
 
 Jalilian, A. (2019). ETAS: An \R package for fitting the space-time ETAS model to earthquake data.
 Journal of Statistical Software, Code Snippets, 88(1), 1–39. doi:10.18637/jss.v088.c01.
 
 Zhuang, J., Y. Ogata, and D. Vere-Jones (2002). Stochastic declustering of
 space-time earthquake occurrences. Journal of the American Statistical
 Association 97(458), 369–380.

 Zhuang, J., Y. Ogata, and D. Vere-Jones (2004). Analyzing earthquake
 clustering features by using stochastic reconstruction. Journal of
 Geophysical Research: Solid Earth 109(B05301).
}
