% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_statistics.R
\name{CUP}
\alias{CUP}
\title{CUP}
\usage{
CUP(observation, fun, permutations = NULL, num.permutations = 1000)
}
\arguments{
\item{observation}{A vector giving the observed partition}

\item{fun}{A function used to compute a given partition statistic to be computed}

\item{permutations}{A matrix, whose lines contain partitions which are permutations of the observed partition.
This argument is NULL by default (in that case, the permutations are created automatically).}

\item{num.permutations}{An integer indicating the number of permutations to generate, if they are not already given.
1000 permutations are generated by default.}
}
\value{
The value of the statistic calculated for the observed partition,
the mean value of the statistic among permuted partitions,
the standard deviation of the statistic among permuted partitions,
the proportion of permutation below the observed statistic,
the proportion of permutation above the observed statistic,
the lower boundary of the 95\% CI,
the upper boundary of the 95\% CI
}
\description{
This function tests a partition statistic against a "conditional uniform partition null hypothesi:
It compares a statistic computed on an observed partition and the same statistic computed on a set of permuted partition
(partitions with the same group structure as the observed partition, with nodes being permuted).
}
\details{
This test is similar to Conditional Uniform Graph tests in networks (we translate this into Condtional Uniform Partition tests).
}
\examples{
p <- c(1,2,2,3,3,4,4,4,5)
at <- c(0,1,1,1,1,0,0,0,0)
CUP(p,fun=function(x){same_pairs(x,at,'avg_pergroup')})
}
