% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVT_utils.R
\name{loss_GPD}
\alias{loss_GPD}
\title{Generalized Pareto likelihood loss}
\usage{
loss_GPD(
  sigma,
  xi,
  y,
  rescaled = TRUE,
  interm_lvl = NULL,
  return_vector = FALSE
)
}
\arguments{
\item{sigma}{Value(s) for the GPD scale parameter.}

\item{xi}{Value(s) for the GPD shape parameter.}

\item{y}{Vector of observations}

\item{rescaled}{Whether y already is a vector of excesses (TRUE) or needs rescaling (FALSE).}

\item{interm_lvl}{Probability level at which the empirical quantile should be used as the intermediate threshold
to compute the excesses, if \code{rescaled==FALSE}.}

\item{return_vector}{Whether to return the the vector of GPD losses for each observation
instead of the negative log-likelihood (average loss).}
}
\value{
GPD negative log-likelihood of the GPD parameters over the sample of observations.
}
\description{
Generalized Pareto likelihood loss
}
