% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_spectrum}
\alias{plot_spectrum}
\title{Plot Empirical and Posterior Predictive Power Spectra}
\usage{
plot_spectrum(
  dat,
  pp = NULL,
  plot.log = TRUE,
  spectrum.args = list(),
  trial_duration = NULL,
  ...
)
}
\arguments{
\item{dat}{A data frame containing empirical reaction time data, with
at least columns \code{subjects} and \code{rt}.}

\item{pp}{Optional posterior predictive data in the same format as
\code{dat}, including \code{subjects}, \code{postn}, and \code{trials}.}

\item{plot.log}{Logical. Whether to log-transform frequencies and
power before plotting. This does not affect the call to
\code{\link{spectrum}}: use \code{spectrum.args$list(log = TRUE)}
to request log spectral density from the estimator itself.}

\item{spectrum.args}{A named list of arguments forwarded directly to
\code{\link{spectrum}} inside \code{\link{get_power_spectra}}.}

\item{trial_duration}{Optional duration of a trial in seconds. If
supplied, the x-axis is labeled in human-readable time units. Otherwise
the x-axis is in (log) frequencies of 1/trial.}

\item{...}{Additional graphical parameters passed to \code{\link{plot}}.}
}
\value{
Invisibly returns a list containing the empirical spectrum
and, if posterior predictive data is supplied, the posterior
predictive spectra and their mean.
}
\description{
Computes and plots the empirical power spectrum, with optional overlay
of spectra from posterior predictive simulations. All customization of
the spectral estimator is done through \code{spectrum.args}, while plot
appearance is controlled via \code{...}.
}
