% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEL.R
\name{BEL.means}
\alias{BEL.means}
\title{The two-sample blockwise empirical likelihood statistic for differences in means}
\usage{
BEL.means(X, Y, M_1, M_2, Delta = 0)
}
\arguments{
\item{X, Y}{vectors of data values.}

\item{M_1, M_2}{positive integers specifying block length for X and Y, respectively.}

\item{Delta}{hypothesized difference of two populations.}
}
\value{
A list of class "htest" containing following components:
method - the character string of the test.
data.name - a character string with the names of the input data.
Delta0 - the specified hypothesized value of mean differences under the null hypothesis
statistic - the value of the test statistic.
p.value - the p-value for the test.
}
\description{
Calculates blockwise empirical likelihood test for the difference of two sample means.
}
\examples{
# Basic example
Delta0 <- 1.5
X <- arima.sim(n = 400, model = list(ar = .3))
Y <- arima.sim(n = 400, model = list(ar = .5)) + Delta0
BEL.means(X, Y, 10, 20, Delta = Delta0)

}
