% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_gme.R
\name{ei_gme}
\alias{ei_gme}
\title{Ecologic Inference applying entropy}
\usage{
ei_gme(fn, dataA, dataB, weights = NULL, tol, v, iter)
}
\arguments{
\item{fn}{Is the formula that represents the dependent variable in the optimization.
In the context of this function, 'fn' is used to define the dependent variable
to be optimized by the entropy function.
Note: If the dependent variable is categorical the sorting criterion for the columns, and therefore for J, is alphabetical order.}

\item{dataA}{The data where the variable of interest y is available and also the independent variables.
Note: The variables and weights used as independent variables must have the same name in 'dataA' and in 'dataB'
The variables in both databases need to match up in content.}

\item{dataB}{The data which contains information on the independent variables at a disaggregated level.
Note: The variables and weights used as independent variables must be the same and must have the same name in 'dataA' and in 'dataB'}

\item{weights}{A character string specifying the column name to be used as weights in both 'dataA' and 'dataB' datasets.
If the argument \code{weights} is provided and present in both datasets,  the weights in each dataset will be normalized by the sum of the weights within that dataset.
If \code{weights} is NULL or the specified column does not exist in both datasets, equal weights are applied across all observations.}

\item{tol}{The tolerance to be applied in the optimization function. If the tolerance is not specified, the default tolerance has been set in 1e-10}

\item{v}{The support vector}

\item{iter}{The maximum number of iterations allowed for the optimization algorithm to run
Increasing the number of iterations may improve the likelihood of finding an optimal solution,
but can also increases computation time.If the maximum number of iterations is not specified, it will default to 1000}
}
\value{
The function will provide you a dataframe called table with the next information:
\itemize{
\item \strong{weights} The weights used in the optimization process.
\item \strong{predictions}  The prediction for each individual is calculated as the sum of the probability plus the error.
\item \strong{probabilities}  Probabilities for each individual to each possibility \code{j} of the variable of interest \code{y}.
\item \strong{errors}  Errors calculated to the \code{j} possibilities of \code{y}.
The function provides information about the optimization process as :
\item \strong{value_of_entropy} The value of entropy resulting from the optimization.
\item \strong{iterations} Indicates the times the objective function and the gradient has been evaluated during the optimization process
\item \strong{message} Indicates the message if it has been generated in the process of optimization
\item \strong{tol} Indicates the tolerance used in the optimization
\item \strong{v} Indicates the vector of support used in the function
The function provides a dataframe containing the information about lambda:
\item  \strong{lambda} The estimated lambda values.
It is provided an object with the restrictions checked which should be approximately zero.
\item  \strong{check restrictions} Being  g1 the restriction related to the unit probability constraint, g2 to the error unit sum constraint, and g3 to the consistency restriction that implies that the difference between the cross moment in both datasets must be zero.
}
The restriction g3 can be checked thoroughly with the objects by separate.
\itemize{
\item  \strong{cross moments A} Cross moments in \code{dataA}.
\item  \strong{cross moments B} Cross moments in \code{dataB}.}
}
\description{
The function ei_gme defines the Shannon entropy function which takes a vector of probabilities as input and returns the negative
sum of p times the natural logarithm of p.The function will set the optimization parameters and using the "nlminb" function an optimal
solution is obtained.
The function defines the independent variables in the two databases needed, which we call dataA with "n_A" observations and dataB
with "n_B" observations; and the function of the binary variable of interest y. Then the weights of each observation for the two
databases used are defined, if there are no weights available it will be 1.
The errors are calculated pondering the support vector of dimension \code{var, 0, -var}. This support vector can be specified by the user.
The default support vector is based on variance.We recommend a wider interval with v(1,0,-1) as the maximum.
The restrictions are defined to guarantee consistency.
The optimization of the Shannon entropy function is solved with "nlminb" function
with maximum number of iterations 1000 and with tolerance
defined by the user.
}
\details{
To solve the optimization upper and lower bounds for p and w are settled, specifically, p and w must be above 0 and lower than 1.
In addition, the initial values of p are settled as a uniform distribution and the errors (w) as 1/L.
}
\examples{
#In this example we use the data of this package
dataA <- financial()
dataB <- social()
# Setting up our function for the dependent variable.
fn               <- dataA$poor_liq ~ Dcollege+Totalincome+Dunemp
#Applying the function ei_gme to our databases. In this case dataA
#is the data where we have our variable of interest dataB is the data
# where we have the information for the disaggregation.
#w can be included if we have weights in both surveys
#Tolerance in this example is fixed in 1e-10 and v will be (1,0,-1)
v=matrix(c(1, 0, -1), nrow = 1)
result  <- ei_gme(fn=fn,dataA=dataA,dataB=dataB,weights="w",v=v)
}
\references{
Fernandez-Vazquez, E., Díaz-Dapena, A., Rubiera-Morollon, F., Viñuela, A., (2020) Spatial Disaggregation of Social Indicators: An Info-Metrics Approach. Social Indicators Research, 152(2), 809–821. https://doi.org/10.1007/s11205-020-02455-z.
}
