% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictionIntervals.R
\name{makeDailyPI}
\alias{makeDailyPI}
\title{Make Daily Prediction Intervals}
\usage{
makeDailyPI(dailyBootOut, eList, fluxUnit = 3)
}
\arguments{
\item{dailyBootOut}{data frame returned from \code{\link{genDailyBoot}}}

\item{eList}{named list with at least the Daily, Sample, and INFO 
dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{fluxUnit}{number representing entry in pre-defined fluxUnit class array. 
\code{\link[EGRET]{printFluxUnitCheatSheet}}}
}
\value{
a list of 2 data frames, one for average concentration, in mg/L
and one for flux (unit depends on fluxUnit argument)
In each data frame the first column is Date. The remaining columns are
quantiles of the flux or concentration (depending on the data frame).
}
\description{
This function takes the output from \code{\link{genDailyBoot}} and 
calculates the quantiles for a daily aggregation.
}
\examples{
eList <- EGRET::Choptank_eList
# This example is only based on 4 iterations
# Actual prediction intervals should be calculated on
# a much larger number of iterations (several hundred).
dailyBoot <- Choptank_dailyBootOut
\donttest{
dailyPcts <- makeDailyPI(dailyBoot, eList)
head(dailyPcts[["flux"]])
head(dailyPcts[["conc"]])
}
}
