EDA.ecdf <- function(fun,lower,upper,n = 30,maxiter,
                     k = 2,k0 = 10,tolerance = 0.01,...){
  exexp <- ExplicitExploration(fun, lower = lower,
                               upper = upper,n = n,
                               maxiter = maxiter,
                               k = k0,tolerance = tolerance,...)
  n_gen <- exexp$n_gen
  historical <- exexp$historical
  best <- list()
  best[[1]] <- as.numeric(exexp$par[1,])
  counter <- 1
  while (n_gen < maxiter) {
    exexp <- EE.ecdf(pobl = exexp$par, fun = fun, n = n,
                     k = k, tolerance = tolerance,
                     n_gen = exexp$n_gen,
                     maxiter = maxiter,...)
    n_gen <- exexp$n_gen
    historical <- c(historical,exexp$historical)
    counter <- counter + 1
    best[[counter]] <- as.numeric(exexp$par[1,])
  }

  par <- as.data.frame(exexp$par)
  value <- sapply(best, fun, ...)
  sol <- as.numeric(best[[which.min(value)]])
  value <- min(value)
  return(list(sol = sol, par = par, value = value,
              historical = historical))
}
